/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.Pad;

public class PadHistoryEditorInput implements IEditorInput {

	private Pad pad;

	public PadHistoryEditorInput(Pad pad) 
	{
		this.pad = pad;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/pad-history.png");
	}

	@Override	public String getName() {
		return "Pad history for " + pad.getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Pad getPad() {
		return this.pad;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o)) {
			return true;
		}
		if( !(o instanceof PadHistoryEditorInput) ) {
			return false;
		}

		PadHistoryEditorInput padEditorInput = (PadHistoryEditorInput)o;
		Pad inputPad = padEditorInput.getPad();

		if(inputPad == null && pad == null) 
		{
			return true;
		}
		else if(inputPad == null && pad != null) 
		{
			return false;
		}
		else if(inputPad != null && pad == null) 
		{
			return false;
		} 
		else if(inputPad != null && pad != null)
		{
			if(inputPad.getId().equals(pad.getId()))
			{
				return true;
			}
			return false;
		}
		
		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getPad() == null || this.getPad().getId() == null) ? 0 : this.getPad().getId().hashCode();
		return retVal;
	}
}
