/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.tmcdb.domain.Pad;

/**
 * Editor input for pads.
 * @author sharring
 */
public class PadEditorInput implements TmcdbObjectEditorInput 
{
	private Pad pad;
	private IModelChangeListener modelChangeListener;
	
	public PadEditorInput(Pad pad, IModelChangeListener modelChangeListener) 
	{
		this.pad = pad;
		this.modelChangeListener = modelChangeListener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/pad.png");
	}

	@Override
	public String getName() {
		return pad.getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + pad.getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Pad getPad() {
		return pad;
	}

	public IModelChangeListener getModelChangeListener() {
		return modelChangeListener;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof PadEditorInput) )
			return false;

		PadEditorInput padEditorInput = (PadEditorInput)o;
		Pad inputPad = padEditorInput.getPad();

		if( inputPad.getId() != null && pad.getId() != null ) {
			if( pad.getId().equals(inputPad.getId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getPad() == null || this.getPad().getId() == null)? 0 : this.getPad().getId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getPad();
	}
}
