/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.NotificationServiceMapping;
import alma.obops.tmcdbgui.utils.ImageHelper;
import alma.obops.tmcdbgui.utils.LabelHelper;

public class NotificationServiceMappingEditorInput implements TmcdbObjectEditorInput {

	private NotificationServiceMapping _nsMapping;

	public NotificationServiceMappingEditorInput(NotificationServiceMapping service) {
		_nsMapping = service;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(_nsMapping);
	}

	@Override public String getName() {
		return LabelHelper.getNotificationServiceMappingLabel(_nsMapping);
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		String retVal = getName() + " in " + _nsMapping.getConfiguration().getConfigurationName();
		return retVal;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public NotificationServiceMapping getNotificationServiceMapping() {
		return _nsMapping;
	}

	public void setNotificationServiceMapping(NotificationServiceMapping cm) {
		_nsMapping = cm;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof NotificationServiceMappingEditorInput) )
			return false;

		NotificationServiceMappingEditorInput cei = (NotificationServiceMappingEditorInput)o;
		NotificationServiceMapping cmapping = cei.getNotificationServiceMapping();

		if( cmapping.getNotificationServiceMappingId() != null && _nsMapping.getNotificationServiceMappingId() != null ) {
			if( _nsMapping.getNotificationServiceMappingId().equals(cmapping.getNotificationServiceMappingId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		
		retVal += (this.getNotificationServiceMapping() == null || this.getNotificationServiceMapping().getNotificationServiceMappingId() == null) 
		   ? 0 : this.getNotificationServiceMapping().getNotificationServiceMappingId().hashCode();
		
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getNotificationServiceMapping().getConfiguration();
	}
}
