/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.Manager;
import alma.obops.tmcdbgui.utils.ImageHelper;

public class ManagerEditorInput implements TmcdbObjectEditorInput 
{
	private Manager manager;

	public ManagerEditorInput(Manager mgr) {
		manager = mgr;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(manager);
	}

	@Override	public String getName() {
		return "Manager of id: " + manager.getManagerId();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Manager getManager() {
		return manager;
	}

	public void setManager(Manager c) {
		manager = c;
	}

	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof ManagerEditorInput) )
			return false;

		ManagerEditorInput cei = (ManagerEditorInput)o;
		Manager c = cei.getManager();

		if( c.getManagerId() != null && manager.getManagerId() != null ) {
			if( manager.getManagerId().equals(c.getManagerId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 0;
		retVal += (this.getManager() == null || this.getManager().getManagerId() == null)? 0: this.getManager().getManagerId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getManager().getConfiguration();
	}
}
