/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import alma.obops.tmcdbgui.handlers.IConfigurationUpdater;

/**
 * Interface for XML editing input.
 * @author sharring
 */
public interface IXmlEditorInput extends TmcdbObjectEditorInput, IConfigurationUpdater
{
	/**
	 * Setter the xml data on the underlying object being edited, but does not
	 * persist it to the persistence layer (this must be done in a separate step).
	 * 
	 * @param xmldata the new xml string/data.
	 */
	public void setXmlForEditedObject(String xmldata);
	
	/**
	 * Getter for the xml data of the underlying object being edited.
	 * @return the xml data of the edited object.
	 */
	public String getXmlForEditedObject();
	
	/**
	 * Getter for whether or not the underlying object that is being edited has
	 * a XML schema (XSD) associated with it or not.
	 * 
	 * @return true if the underlying object has an associated schema; false otherwise.
	 */
	public boolean editedObjectHasXmlSchema();
	
	/**
	 * Getter for the xml schema for the underlying object that is being edited.
	 * 
	 * @return the xml schema, as a string, for the underlying object that is
	 * being edited; null if there is no schema associated.
	 */
	public String getXmlSchemaForEditedObject();
	
	/**
	 * Getter to indicate if the editor should be invoked in 'read only' mode.
	 */
	public boolean isReadOnly();
}
