/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.BaseElementConversationUtils;
import alma.tmcdb.domain.HolographyTowerToPad;

public class HolographyTowerToPadEditorInput implements TmcdbObjectEditorInput 
{
	private HolographyTowerToPad holographyTowerToPad;
	String holographyTowerName;
	String padName;

	public HolographyTowerToPadEditorInput(HolographyTowerToPad h2p) 
	{
		holographyTowerToPad = h2p;
		try {
			padName = BaseElementConversationUtils.getInstance().findPadById(h2p.getPad().getId()).getName();
			if(!h2p.getPad().getConfiguration().getId().equals(h2p.getHolographyTower().getConfiguration().getId())) {
				String qualifiedPadName = h2p.getHolographyTower().getConfiguration().getName() + ":" + padName;
				padName = qualifiedPadName;
			}
		} catch (Exception e) {
			e.printStackTrace();
			padName = null;
		}
		holographyTowerName = h2p.getHolographyTower().getName();
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/holographyTowerToPad.png");
	}

	@Override	
	public String getName() {
		return padName + " to " + holographyTowerName;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + holographyTowerToPad.getPad().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public HolographyTowerToPad getHolographyTowerToPad() {
		return holographyTowerToPad;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof HolographyTowerToPadEditorInput) )
			return false;

		HolographyTowerToPadEditorInput editorInput = (HolographyTowerToPadEditorInput)o;
		HolographyTowerToPad inputHoloTowerToPad = editorInput.getHolographyTowerToPad();

		if( inputHoloTowerToPad.getHolographyTowerToPadId() != null && holographyTowerToPad.getHolographyTowerToPadId() != null ) {
			if( holographyTowerToPad.getHolographyTowerToPadId().equals(inputHoloTowerToPad.getHolographyTowerToPadId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getHolographyTowerToPad() == null || this.getHolographyTowerToPad().getHolographyTowerToPadId() == null) 
		   ? 0 : this.getHolographyTowerToPad().getHolographyTowerToPadId().hashCode();  
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getHolographyTowerToPad();
	}
}
