/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import java.util.Set;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.XPDelay;
import alma.tmcdb.history.HistoryRecord;

public class HistoricalXpDelaysEditorInput implements IEditorInput 
{
	private HwConfiguration owningConfig;
	private Set<XPDelay> referenceDm;
	private Set<XPDelay> previousDm;
	private HistoryRecord historyRecord;
	private String overrideName;

	public HistoricalXpDelaysEditorInput(Set<XPDelay> referenceDm, Set<XPDelay> previousDm, HistoryRecord record, HwConfiguration config) 
	{
		this.referenceDm = referenceDm;
		this.previousDm = previousDm;
		this.historyRecord = record;
		this.owningConfig = config;
	}
	
	public HistoricalXpDelaysEditorInput(Set<XPDelay> previousDm, Set<XPDelay> referenceDm, HistoryRecord record, String name, HwConfiguration config) 
	{
		this(previousDm, referenceDm, record, config);
		this.overrideName = name;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/delays-history.png");
	}

	public String getName() 
	{
		String retVal = null;
		if(null != overrideName)
		{
			retVal = overrideName;
		}
		else 
		{
			retVal = "Delay model v." + historyRecord.getVersion().toString() + " for config " + owningConfig.getName();			
		}
		return retVal;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}
	
	public Set<XPDelay> getReferenceXpDelay()
	{
		return this.referenceDm;
	}
	
	public Set<XPDelay> getPreviousXpDelay()
	{
		return this.previousDm;
	}
	
	public HistoryRecord getHistoryRecord() { return historyRecord; }
	
	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof HistoricalXpDelaysEditorInput) )
			return false;
		
		return this.getName().equals( ((HistoricalXpDelaysEditorInput)o).getName());
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getName() == null) ? 0 : this.getName().hashCode();
		return retVal;
	}

}
