/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.Pad;
import alma.tmcdb.history.HistoryRecord;

public class HistoricalPadEditorInput implements IEditorInput 
{

	private Pad referencePad;
	private Pad previousPad;
	private HistoryRecord historyRecord;
	private String overrideName;
	
	public HistoricalPadEditorInput(Pad pad, Pad previousPad, HistoryRecord record) 
	{
		this.referencePad = pad;
		this.previousPad = previousPad;
		this.historyRecord = record;
	}

	public HistoricalPadEditorInput(Pad pad, Pad previousPad, HistoryRecord record, String name) 
	{
		this(pad, previousPad, record);
		this.overrideName = name;
	}
	
	public Pad getReferencePad() {
		return this.referencePad;
	}
	
	public Pad getPreviousPad() {
		return this.previousPad;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/pad-history.png");
	}

	public String getName() 
	{
		String retVal = null;
		if(null != overrideName) {
			retVal = overrideName;
		}
		else {
			retVal = "Pad v." + historyRecord.getVersion().toString() + " for " + referencePad.getName();	
		}
		return retVal;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}
	
	public Pad getCurrentPad()
	{
		return this.previousPad;
	}
	
	public HistoryRecord getHistoryRecord() { return historyRecord; }
	
	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof HistoricalPadEditorInput) )
			return false;

		HistoricalPadEditorInput padEditorInput = (HistoricalPadEditorInput)o;
		Pad inputPad = padEditorInput.getReferencePad();

		if(inputPad.getId() == null && this.getReferencePad().getId() != null) {
			return false;
		}
		else if(inputPad.getId() != null && this.getReferencePad().getId() == null) {
			return false;
		}
		else if(inputPad.getId() == null && this.getReferencePad().getId() == null) 
		{
		   if(inputPad.equals(this.getReferencePad()) && 
			  padEditorInput.getHistoryRecord().getVersion().equals(this.getHistoryRecord().getVersion()))
		   {
			   return true;
		   }
		return false;
		}
		
		if( inputPad.getId() != null && this.getReferencePad().getId() != null ) 
		{
			if( this.getReferencePad().getId().equals(inputPad.getId()) &&
				this.getHistoryRecord().getVersion().equals(padEditorInput.getHistoryRecord().getVersion()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getHistoryRecord().getVersion() == null ? 0: this.getHistoryRecord().getVersion().hashCode();
		return retVal;
	}

}
