/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.AntennaToPadUtils;
import alma.tmcdb.domain.AntennaToPad;
import alma.tmcdb.history.HistoryRecord;

/**
 * @author sharring
 *
 */
public class HistoricalAntennaToPadEditorInput implements IEditorInput 
{

	private AntennaToPad referenceAntennaToPad;
	private AntennaToPad previousAntennaToPad;
	private HistoryRecord historyRecord;
	private String overrideName;
	
	public HistoricalAntennaToPadEditorInput(AntennaToPad a2p, AntennaToPad previousAntennaToPad, HistoryRecord record) 
	{
		this.referenceAntennaToPad = a2p;
		this.previousAntennaToPad = previousAntennaToPad;
		this.historyRecord = record;
	}

	public HistoricalAntennaToPadEditorInput(AntennaToPad a2p, AntennaToPad previousAntennaToPad, HistoryRecord record, String name) 
	{
		this(a2p, previousAntennaToPad, record);
		this.overrideName = name;
	}
	
	public AntennaToPad getReferenceAntennaToPad() {
		return this.referenceAntennaToPad;
	}
	
	public AntennaToPad getPreviousAntennaToPad() {
		return this.previousAntennaToPad;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/a2p-history.png");
	}

	public String getName() 
	{
		String retVal = null;
		if(null != overrideName) {
			retVal = overrideName;
		}
		else {
			String identifier = AntennaToPadUtils.getAntennaToPadIdentifier(referenceAntennaToPad);
			retVal = "AntennaToPad v." + historyRecord.getVersion().toString() + " for " + identifier;
		}
		return retVal;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}
	
	public AntennaToPad getCurrentAntennaToPad()
	{
		return this.previousAntennaToPad;
	}
	
	public HistoryRecord getHistoryRecord() { return historyRecord; }
	
	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof HistoricalAntennaToPadEditorInput) )
			return false;

		HistoricalAntennaToPadEditorInput a2pEditorInput = (HistoricalAntennaToPadEditorInput)o;
		AntennaToPad inputAntennaToPad = a2pEditorInput.getReferenceAntennaToPad();

		if(inputAntennaToPad.getAntennaToPadId() == null && this.getReferenceAntennaToPad().getAntennaToPadId() != null) {
			return false;
		}
		else if(inputAntennaToPad.getAntennaToPadId() != null && this.getReferenceAntennaToPad().getAntennaToPadId() == null) {
			return false;
		}
		else if(inputAntennaToPad.getAntennaToPadId() == null && this.getReferenceAntennaToPad().getAntennaToPadId() == null) 
		{
		   if(inputAntennaToPad.equals(this.getReferenceAntennaToPad()) && 
			  a2pEditorInput.getHistoryRecord().getVersion().equals(this.getHistoryRecord().getVersion()))
		   {
			   return true;
		   }
		return false;
		}
		
		if( inputAntennaToPad.getAntennaToPadId() != null && this.getReferenceAntennaToPad().getAntennaToPadId() != null ) 
		{
			if( this.getReferenceAntennaToPad().getAntennaToPadId().equals(inputAntennaToPad.getAntennaToPadId()) &&
				this.getHistoryRecord().getVersion().equals(a2pEditorInput.getHistoryRecord().getVersion()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getHistoryRecord().getVersion() == null ? 0: this.getHistoryRecord().getVersion().hashCode();
		return retVal;
	}

}