/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.FocusModel;

/**
 * Editor input for focus model history editor.
 * 
 * @author sharring
 *
 */
public class FocusModelHistoryEditorInput implements IEditorInput 
{
	private FocusModel focusModel;

	public FocusModelHistoryEditorInput(FocusModel pm) 
	{
		this.focusModel = pm;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/focusmodel-history.png");
	}

	@Override	public String getName() {
		return "Focus model history for " + focusModel.getAntenna().getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + focusModel.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public FocusModel getFocusModel() {
		return this.focusModel;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o)) {
			return true;
		}
		if( !(o instanceof FocusModelHistoryEditorInput) ) {
			return false;
		}

		FocusModelHistoryEditorInput pmEditorInput = (FocusModelHistoryEditorInput)o;
		FocusModel inputFocusModel = pmEditorInput.getFocusModel();

		if(inputFocusModel == null && focusModel == null) 
		{
			return true;
		}
		else if(inputFocusModel == null && focusModel != null) 
		{
			return false;
		}
		else if(inputFocusModel != null && focusModel == null) 
		{
			return false;
		} 
		else if(inputFocusModel != null && focusModel != null)
		{
			if(inputFocusModel.getId() == null && focusModel.getId() == null)
			{
				if(inputFocusModel.getAntenna().getId().equals(focusModel.getAntenna().getId()))
				{
					return true;
				}
				return false;
			} 
			else if(inputFocusModel.getId() == null && focusModel.getId() != null) 
			{
				return false;
			}
			else if(inputFocusModel.getId() != null && focusModel.getId() == null) 
			{
				return false;
			}
			else if( inputFocusModel.getId() != null && focusModel.getId() != null ) 
			{
				if( focusModel.getId().equals(inputFocusModel.getId()) ) {
					return true;
				}
				return false;
			}
		}
		
		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getFocusModel() == null ? 0 : this.getFocusModel().hashCode();
		return retVal;
	}
}
