/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.obops.tmcdbgui.views.providers.helpers.config.DelayModel;

public class DelayModelEditorInput implements TmcdbObjectEditorInput {

	private DelayModel delayModel;
	private IModelChangeListener modelChangeListener;
	
	public DelayModelEditorInput(DelayModel fm,
			IModelChangeListener listener) 
	{
		delayModel = fm;
		this.modelChangeListener = listener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	public String getName() {
		return "Delays for " + this.delayModel.getAntenna().getName();
	}
	
	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/delays.png");
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + this.delayModel.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}
	
	public DelayModel getDelayModel() {
		return this.delayModel;
	}
	
	public IModelChangeListener getModelChangeListener()
	{
		return this.modelChangeListener;
	}

	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof DelayModelEditorInput) )
			return false;

		DelayModelEditorInput pmEditorInput = (DelayModelEditorInput)o;
		DelayModel inputDm = pmEditorInput.getDelayModel();

		return this.getDelayModel().equals(inputDm);
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getDelayModel() == null ? 0 : this.getDelayModel().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getDelayModel().getAntenna();
	}

}
