/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.DefaultCanAddress;
import alma.obops.tmcdbgui.editors.DefaultCanAddressEditor;
import alma.obops.tmcdbgui.utils.ImageHelper;
import alma.obops.tmcdbgui.utils.LabelHelper;

/**
 * Input wrapper for the {@link DefaultCanAddressEditor} editor.
 * @author rtobar, Aug 18th, 2010
 *
 */
public class DefaultCanAddressEditorInput implements TmcdbObjectEditorInput {

	private DefaultCanAddress _dca;

	public DefaultCanAddressEditorInput(DefaultCanAddress cont) {
		_dca = cont;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(_dca);
	}

	@Override	public String getName() {
		return _dca.getComponent().getComponentName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return LabelHelper.getFullPath(_dca.getComponent(), false);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public DefaultCanAddress getDefaultCanAddress() {
		return _dca;
	}

	public void setDefaultCanAddress(DefaultCanAddress dca) {
		_dca = dca;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof DefaultCanAddressEditorInput) )
			return false;

		DefaultCanAddressEditorInput cei = (DefaultCanAddressEditorInput)o;
		DefaultCanAddress c = cei.getDefaultCanAddress();

		if( c.getComponentId() != null && _dca.getComponentId() != null ) {
			if( _dca.getComponentId().equals(c.getComponentId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getDefaultCanAddress() == null || this.getDefaultCanAddress().getComponent() == null 
				   || this.getDefaultCanAddress().getComponentId() == null) 
				   ? 0 : this.getDefaultCanAddress().getComponentId().hashCode(); 
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getDefaultCanAddress();
	}
}
