/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.ContainerStartupOption;
import alma.obops.tmcdbgui.utils.ImageHelper;

public class ContainerStartupOptionEditorInput implements TmcdbObjectEditorInput 
{
	private ContainerStartupOption _option;

	public ContainerStartupOptionEditorInput(ContainerStartupOption opt) {
		_option = opt;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(_option);
	}

	@Override	public String getName() {
		return _option.getOptionName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return _option.getOptionName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public ContainerStartupOption getContainerStartupOption() {
		return _option;
	}

	public void setContainerStartupOption(ContainerStartupOption c) {
		_option = c;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof ContainerStartupOptionEditorInput) )
			return false;

		ContainerStartupOptionEditorInput cei = (ContainerStartupOptionEditorInput)o;
		ContainerStartupOption c = cei.getContainerStartupOption();

		if( c.getContStartOptId() != null && _option.getContStartOptId() != null ) {
			if( _option.getContStartOptId().equals(c.getContStartOptId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getContainerStartupOption() == null || this.getContainerStartupOption().getContStartOptId() == null)
		   ? 0 : this.getContainerStartupOption().getContStartOptId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getContainerStartupOption();
	}
}
