/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ContainerEditorInput
 */
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.Container;
import alma.obops.tmcdbgui.editors.ContainerEditor;
import alma.obops.tmcdbgui.utils.ImageHelper;
import alma.obops.tmcdbgui.utils.LabelHelper;

/**
 * Input wrapper for the {@link ContainerEditor} editor.
 * @author rtobar, Feb 25, 2010
 *
 */
public class ContainerEditorInput implements TmcdbObjectEditorInput {

	private Container _container;

	public ContainerEditorInput(Container cont) {
		_container = cont;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(_container);
	}

	@Override	public String getName() {
		return _container.getContainerName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return LabelHelper.getFullPath(_container, false);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Container getContainer() {
		return _container;
	}

	public void setContainer(Container c) {
		_container = c;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof ContainerEditorInput) )
			return false;

		ContainerEditorInput cei = (ContainerEditorInput)o;
		Container c = cei.getContainer();

		if( c.getContainerId() != null && _container.getContainerId() != null ) {
			if( _container.getContainerId().equals(c.getContainerId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getContainer() == null || this.getContainer().getContainerId() == null) 
		   ? 0 : this.getContainer().getContainerId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getContainer();
	}
}
