/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComputerEditorInput
 */
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.Computer;
import alma.obops.tmcdbgui.editors.ComputerEditor;
import alma.obops.tmcdbgui.utils.ImageHelper;
import alma.obops.tmcdbgui.utils.LabelHelper;

/**
 * Input wrapper for the {@link ComputerEditor} editor.
 * @author rtobar, Mar 4, 2010
 *
 */
public class ComputerEditorInput implements TmcdbObjectEditorInput {

	private Computer _computer;

	public ComputerEditorInput(Computer cont) {
		_computer = cont;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(_computer);
	}

	@Override	public String getName() {
		return _computer.getNetworkName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return LabelHelper.getComputerLabel(_computer);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Computer getComputer() {
		return _computer;
	}

	public void setComputer(Computer c) {
		_computer = c;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof ComputerEditorInput) )
			return false;

		ComputerEditorInput cei = (ComputerEditorInput)o;
		Computer c = cei.getComputer();

		if( c.getNetworkDeviceId() != null && _computer.getNetworkDeviceId() != null ) {
			if( _computer.getNetworkDeviceId().equals(c.getNetworkDeviceId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getComputer() == null || this.getComputer().getNetworkDeviceId() == null)
		   ? 0 : this.getComputer().getNetworkDeviceId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getComputer();
	}
}
