/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComputerEditorInput
 */
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.Component;
import alma.obops.tmcdbgui.editors.ComputerEditor;
import alma.obops.tmcdbgui.utils.LabelHelper;

/**
 * Input wrapper for the {@link ComputerEditor} editor.
 * @author rtobar, Mar 4, 2010
 *
 */
public class ComponentXmlEditorInput implements IXmlEditorInput {

	private Component component;

	public ComponentXmlEditorInput(Component component) {
		this.component = component;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return null;//ImageHelper.getImageDescriptor(_computer);
	}

	@Override
	public String getName() {
		String retVal = component.getComponentName() + ".XMLDoc";
		return retVal;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		String retVal = LabelHelper.getFullPath(component, false) + ".XMLDoc";
		return retVal;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Component getComponent() {
		return component;
	}

	@Override
	public String getXmlForEditedObject() {
		String retVal = component.getXMLDoc();
		return retVal;
	}

	@Override
	public void setXmlForEditedObject(String xml) {
		component.setXMLDoc(xml);
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof ComponentXmlEditorInput) )
			return false;

		ComponentXmlEditorInput o2 = (ComponentXmlEditorInput)o;
		
		if( o2 == this || o2.equals(this) )
			return true;
		
		Component c2 = o2.getComponent();
		Component c1 = this.getComponent();

		if( c2 == c1 || c2.equals(c1) )
			return true;
		
		return false;

	}

	@Override
	public String getXmlSchemaForEditedObject() {
		return null;
	}

	@Override
	public boolean editedObjectHasXmlSchema() {
		return false;
	}

	@Override
	public void updateConfiguration() {
		// TODO Auto-generated method stub
	}

	@Override
	public boolean isReadOnly() {
		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getComponent() == null || this.getComponent().getComponentId() == null) 
		   ? 0 : this.getComponent().getComponentId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getComponent();
	}

}
