/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.BACIProperty;
import alma.obops.tmcdbgui.utils.ImageHelper;
import alma.obops.tmcdbgui.utils.LabelHelper;

/**
 * Editor input for baci properties.
 * @author sharring
 */
public class BACIPropertyEditorInput implements TmcdbObjectEditorInput {

	private BACIProperty baciProperty;
	
	public BACIPropertyEditorInput(BACIProperty bp) {
		baciProperty = bp;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return ImageHelper.getImageDescriptor(baciProperty);
	}

	@Override	public String getName() {
		return baciProperty.getPropertyName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return LabelHelper.getFullPath(baciProperty, false);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public BACIProperty getBACIProperty() {
		return baciProperty;
	}

	public void setBACIProperty(BACIProperty bp) {
		baciProperty = bp;
	}

	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof BACIPropertyEditorInput) )
			return false;

		BACIPropertyEditorInput bpei = (BACIPropertyEditorInput)o;
		BACIProperty bp = bpei.getBACIProperty();

		if( bp.getBACIPropertyId() != null && baciProperty.getBACIPropertyId() != null ) {
			if( baciProperty.getBACIPropertyId().equals(bp.getBACIPropertyId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getBACIProperty() == null || this.getBACIProperty().getBACIPropertyId() == null) 
		   ? 0: this.getBACIProperty().getBACIPropertyId().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getBACIProperty();
	}
}