/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.LabelHelper;
import alma.tmcdb.domain.Assembly;

public class AssemblyEditorInput implements TmcdbObjectEditorInput 
{
	private Assembly assembly;
	
	public AssemblyEditorInput(Assembly assembly)
	{
		this.assembly = assembly;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/assembly.png");
	}

	@Override
	public String getName() {
		return LabelHelper.getAssemblyLabel(getAssembly());
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return LabelHelper.getAssemblyLabel(assembly) + " in " + assembly.getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public Assembly getAssembly() {
		return assembly;
	}

	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof AssemblyEditorInput) )
			return false;

		AssemblyEditorInput assemblyEditorInput = (AssemblyEditorInput)o;
		Assembly ass = assemblyEditorInput.getAssembly();

		if( ass.getId() != null && assembly.getId() != null ) {
			if( assembly.getId().equals(ass.getId()) ) {
				return true;
			}
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getAssembly() == null ? 0 : this.getAssembly().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getAssembly();
	}
}
