/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.AntennaToPad;

/**
 * @author sharring
 *
 */
public class AntennaToPadHistoryEditorInput implements IEditorInput 
{
	private AntennaToPad antennaToPad;

	public AntennaToPadHistoryEditorInput(AntennaToPad a2p) 
	{
		this.antennaToPad = a2p;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/antennatopad-history.png");
	}

	@Override	public String getName() {
		return "Antenna-to-pad history for " + antennaToPad.getAntenna().getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + antennaToPad.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public AntennaToPad getAntennaToPad() {
		return this.antennaToPad;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o)) {
			return true;
		}
		if( !(o instanceof AntennaToPadHistoryEditorInput) ) {
			return false;
		}

		AntennaToPadHistoryEditorInput a2pEditorInput = (AntennaToPadHistoryEditorInput)o;
		AntennaToPad inputAntennaToPad = a2pEditorInput.getAntennaToPad();

		if(inputAntennaToPad == null && antennaToPad == null) 
		{
			return true;
		}
		else if(inputAntennaToPad == null && antennaToPad != null) 
		{
			return false;
		}
		else if(inputAntennaToPad != null && antennaToPad == null) 
		{
			return false;
		} 
		else if(inputAntennaToPad != null && antennaToPad != null)
		{
			if(inputAntennaToPad.getAntennaToPadId() == null && antennaToPad.getAntennaToPadId() == null)
			{
				if(inputAntennaToPad.getAntenna().getId().equals(antennaToPad.getAntenna().getId()))
				{
					return true;
				}
				return false;
			} 
			else if(inputAntennaToPad.getAntennaToPadId() == null && antennaToPad.getAntennaToPadId() != null) 
			{
				return false;
			}
			else if(inputAntennaToPad.getAntennaToPadId() != null && antennaToPad.getAntennaToPadId() == null) 
			{
				return false;
			}
			else if( inputAntennaToPad.getAntennaToPadId() != null && antennaToPad.getAntennaToPadId() != null ) 
			{
				if( antennaToPad.getAntennaToPadId().equals(inputAntennaToPad.getAntennaToPadId()) ) {
					return true;
				}
				return false;
			}
		}
		
		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getAntennaToPad() == null || this.getAntennaToPad().getAntennaToPadId() == null) ? 0 : this.getAntennaToPad().getAntennaToPadId().hashCode();
		return retVal;
	}
}