/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.AntennaToPad;

public class AntennaToPadEditorInput implements TmcdbObjectEditorInput 
{
	private AntennaToPad antennaToPad;
	String antennaName;
	String padName;

	public AntennaToPadEditorInput(AntennaToPad a2p) 
	{
		antennaToPad = a2p;
		antennaName = a2p.getAntenna().getName();
		padName = a2p.getPad().getName();
		if(!a2p.getPad().getConfiguration().getId().equals(a2p.getAntenna().getConfiguration().getId())) {
			String qualifiedPadName = a2p.getPad().getConfiguration().getName() + ":" + padName;
			padName = qualifiedPadName;
		}
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/antennaToPad.png");
	}

	@Override	
	public String getName() {
		return antennaName + " on " + padName;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		String retVal = getName() + " in " + getAntennaToPad().getAntenna().getConfiguration().getName();
		return retVal;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public AntennaToPad getAntennaToPad() {
		return antennaToPad;
	}
	
	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof AntennaToPadEditorInput) )
			return false;

		AntennaToPadEditorInput editorInput = (AntennaToPadEditorInput)o;
		AntennaToPad inputAntToPad = editorInput.getAntennaToPad();

		if( inputAntToPad.getAntennaToPadId() != null && antennaToPad.getAntennaToPadId() != null ) {
			if( antennaToPad.getAntennaToPadId().equals(inputAntToPad.getAntennaToPadId()) )
				return true;
			return false;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getAntennaToPad() == null ? 0 : this.getAntennaToPad().hashCode();
		return retVal;
	}

	/* (non-Javadoc)
	 * @see alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput#getDomainObject()
	 */
	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getAntennaToPad();
	}
}
