/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.AcaCorrDelays;

/**
 * @author sharring
 *
 */
public class AcaCorrDelaysHistoryEditorInput implements IEditorInput 
{
	private AcaCorrDelays acaCorrDelays;

	public AcaCorrDelaysHistoryEditorInput(AcaCorrDelays acaCorrDelays) 
	{
		this.acaCorrDelays = acaCorrDelays;
	}

	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/delays.png");
	}

	@Override	public String getName() {
		return "ACA correlator delays history for " + acaCorrDelays.getAntenna().getName();
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + acaCorrDelays.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public AcaCorrDelays getAcaCorrDelays() {
		return this.acaCorrDelays;
	}
	
	public boolean equals(Object o) 
	{
		if(super.equals(o)) {
			return true;
		}
		if( !(o instanceof AcaCorrDelaysHistoryEditorInput) ) {
			return false;
		}

		AcaCorrDelaysHistoryEditorInput delaysEditorInput = (AcaCorrDelaysHistoryEditorInput)o;
		AcaCorrDelays inputDelays = delaysEditorInput.getAcaCorrDelays();

		if(inputDelays == null && acaCorrDelays == null) 
		{
			return true;
		}
		else if(inputDelays == null && acaCorrDelays != null) 
		{
			return false;
		}
		else if(inputDelays != null && acaCorrDelays == null) 
		{
			return false;
		} 
		else if(inputDelays != null && acaCorrDelays != null &&
				inputDelays.getDelayBbFour().equals(acaCorrDelays.getDelayBbFour()) &&
				inputDelays.getDelayBbThree().equals(acaCorrDelays.getDelayBbThree()) &&
				inputDelays.getDelayBbTwo().equals(acaCorrDelays.getDelayBbTwo()) &&
				inputDelays.getDelayBbOne().equals(acaCorrDelays.getDelayBbOne()))
		{
			return true;
		}
		
		return false;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getAcaCorrDelays() == null) ? 0 : this.getAcaCorrDelays().hashCode();
		return retVal;
	}
}
