/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;
import alma.tmcdb.domain.AcaCorrDelays;

/**
 * @author sharring
 *
 */
public class AcaCorrDelaysEditorInput implements TmcdbObjectEditorInput
{
	private AcaCorrDelays delays;
	private IModelChangeListener modelChangeListener;
	
	public AcaCorrDelaysEditorInput(AcaCorrDelays delays,
			IModelChangeListener listener) 
	{
		this.delays = delays;
		this.modelChangeListener = listener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	public String getName() {
		return "ACA correlator delays for " + this.delays.getAntenna().getName();
	}
	
	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/delays.png");
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName() + " in " + this.delays.getAntenna().getConfiguration().getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}
	
	public AcaCorrDelays getAcaCorrDelays() {
		return this.delays;
	}
	
	public IModelChangeListener getModelChangeListener()
	{
		return this.modelChangeListener;
	}

	public boolean equals(Object o) 
	{
		if(super.equals(o))
			return true;
		if( !(o instanceof AcaCorrDelaysEditorInput) )
			return false;

		AcaCorrDelaysEditorInput pmEditorInput = (AcaCorrDelaysEditorInput)o;
		AcaCorrDelays inputDm = pmEditorInput.getAcaCorrDelays();

		return this.getAcaCorrDelays().equals(inputDm);
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getAcaCorrDelays() == null ? 0 : this.getAcaCorrDelays().hashCode();
		return retVal;
	}

	@Override
	public Object getTopLevelDomainObjectForLocking() {
		return this.getAcaCorrDelays().getAntenna();
	}
}
