/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.editors;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

import alma.obops.tmcdbgui.editors.inputs.TmcdbObjectEditorInput;
import alma.obops.tmcdbgui.utils.conversation.BackendConversationUtils;

/**
 * @author sharring
 *
 */
public abstract class TmcdbObjectEditorPart extends EditorPart 
{
	protected void lockEditedObject(Object editedObj) {
		try {
			BackendConversationUtils.getInstance().reAttach(editedObj);
		} 
		catch(InvocationTargetException ex) {
			Throwable cause = ex.getCause();
			String msg = cause.getMessage();
			if(msg.contains("dirty collection")) {
				// noop; this means we're editing (creating) a new object that has not yet been saved.
				// i.e. hibernate throws an exception if you attempt to reattach a new/unsaved/transient object.
			}
			else {
				ex.printStackTrace();
				throw new RuntimeException(ex);
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	
	protected abstract void specializedInit(IEditorSite site, TmcdbObjectEditorInput input) throws PartInitException;
	
	@Override
	public void init(IEditorSite site, IEditorInput input) throws PartInitException
	{
		TmcdbObjectEditorInput tmcdbObjInput = (TmcdbObjectEditorInput) input;
		lockEditedObject(tmcdbObjInput.getTopLevelDomainObjectForLocking());			
		specializedInit(site, tmcdbObjInput);
	}
}
