/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.domain;

/**
 * Interface which is used to listen for changes to the domain model.
 * This interface is used to decouple (or more loosely couple) the
 * views from the actions, so that actions need not 'know about' 
 * views explicitly. Thus, when an action makes changes to 
 * the domain model, it can notify all interested parties/listeners 
 * via this interface.  
 * 
 * @author sharring
 * 
 * @see IModelChangePublisher
 */
public interface IModelChangeListener 
{
	/**
	 * This method is invoked on the listener, if it has been properly registered 
	 * with a publisher, when the domain model has been changed internally.
	 * 
	 * An "internal" change to the model would be when something internal to a 
	 * domain/ configuration hierarchy, has changed, e.g. the addition of base 
	 * elements, the addition of a startup scenario, etc. 
	 * 
	 * A typical response to the model changing internally would be for a view, which has
	 * registered as a listener, to refresh.
	 */
	public void internalModelChange();
	
	/**
	 * This method is invoked on the listener, if it has been properly registered 
	 * with a publisher, whenever the domain model has changed externally, usually meaning 
	 * that the domain object(s) should be reloaded from the database.
	 * 
	 * An 'external' change to the model would be like the addition of a new configuration,
	 * such that the list of configurations should be re-queried, or other large-scale
	 * model changes that exist outside the scope of a single domain / configuration object
	 * hierarchy.
	 * 
	 * A typical response to the model changing externally would be for a view, which has
	 * registered as a listener, to reload the domain object(s) from the database.
	 */
	public void externalModelChange();
}
