/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ContainerSelectionDialog.java
 */
package alma.obops.tmcdbgui.dialogs;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.Container;
import alma.obops.tmcdbgui.utils.conversation.ContainerConversationUtils;

/**
 * The <code>ContainerSelectionDialog</code> is used to select a
 * Container from all the available containers for a given Configuration.
 * This is useful for wizards and views that need to work with a given
 * Container.
 * 
 * The returned type of this dialog is {@link Container}.
 * 
 * @author rtobar, Mar 3, 2010
 *
 */
public class ContainerSelectionDialog extends ElementListSelectionDialog {

	public ContainerSelectionDialog(Shell parent, ILabelProvider renderer, Configuration config) {
		super(parent, renderer);

		try {
			ContainerConversationUtils.getInstance().hydrateContainers(config);
		} catch(Exception e) {
			e.printStackTrace();
		}
		setElements(config.getContainers().toArray(new Container[0]));

		setIgnoreCase(true);
		setMessage("Select a container");
		setMultipleSelection(false);
	}

	protected Control createDialogArea(Composite parent) {
		Control control = super.createDialogArea(parent);
		getShell().setText("Container selection");
		return control;
	}
	
}