/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ConfigurationSelectionDialog.java
 */
package alma.obops.tmcdbgui.dialogs;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.obops.tmcdbgui.utils.conversation.HwConfigurationConversationUtils;
import alma.tmcdb.domain.HwConfiguration;

/**
 * The <code>ConfigurationSelectionDialog</code> is used to select a
 * Configuration from all the available configurations. This is useful
 * for wizards and views that need to work with a given Configuration.
 * 
 * The returned type of this dialog is {@link HwConfiguration}.
 * 
 * @author rtobar, Mar 1, 2010
 *
 */
public class ConfigurationSelectionDialog extends ElementListSelectionDialog 
{
	public ConfigurationSelectionDialog(boolean queryAllActiveStates, boolean activeFlag, Shell parent, ILabelProvider renderer) 
	{
		super(parent, renderer);

		String[] configs = null;
		Cursor cursor = parent.getCursor();
		try {
			parent.setCursor(parent.getDisplay().getSystemCursor(SWT.CURSOR_WAIT));
			
			if(queryAllActiveStates) {
				configs = HwConfigurationConversationUtils.getInstance().getConfigurationNames().toArray(new String[0]);
			}
			else {
				configs = HwConfigurationConversationUtils.getInstance().getConfigurationNames(activeFlag).toArray(new String[0]);
			}
			
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			parent.setCursor(cursor);
		}
		setElements(configs);

		setIgnoreCase(true);
		setMessage("Select a configuration");
		setMultipleSelection(false);
	}
	
	public ConfigurationSelectionDialog(String[] configs, Shell parent, ILabelProvider renderer)
	{
		super(parent, renderer);
		setElements(configs);
		setIgnoreCase(true);
		setMessage("Select a configuration");
		setMultipleSelection(false);
	}

	public ConfigurationSelectionDialog(Shell shell, 
			ConfigurationSelectionDialogLabelProvider configurationSelectionDialogLabelProvider) 
	{
		this(true, false, shell, configurationSelectionDialogLabelProvider);
	}

	protected Control createDialogArea(Composite parent) {
		Control control = super.createDialogArea(parent);
		getShell().setText("Configuration selection");
		return control;
	}
	
}