/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComputerSelectionDialog.java
 */
package alma.obops.tmcdbgui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.NetworkDevice;
import alma.obops.tmcdbgui.utils.conversation.ComputerConversationUtils;

/**
 * The <code>ComputerSelectionDialog</code> is used to select a
 * Computer from all the available computers for a given Configuration.
 * This is useful for wizards and views that need to work with a given
 * Computer.
 * 
 * The returned type of this dialog is {@link Computer}.
 * 
 * @author rtobar, Mar 1, 2010
 *
 */
public class ComputerSelectionDialog extends ElementListSelectionDialog {

	public ComputerSelectionDialog(Shell parent, ILabelProvider renderer, Configuration config) {
		super(parent, renderer);

		try {
			ComputerConversationUtils.getInstance().hydrateComputers(config);
		} catch(Exception e) {
			e.printStackTrace();
		}
		List<Computer> computers = new ArrayList<Computer>();
		for(NetworkDevice nd: config.getNetworkDevices())
			if( nd instanceof Computer)
				computers.add((Computer)nd);
		setElements(computers.toArray(new Computer[0]));

		setIgnoreCase(true);
		setMessage("Select a computer");
		setMultipleSelection(false);
	}

	protected Control createDialogArea(Composite parent) {
		Control control = super.createDialogArea(parent);
		getShell().setText("Computer selection");
		return control;
	}
	
}