/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComponentTypeSelectionDialog.java
 */
package alma.obops.tmcdbgui.dialogs;

import java.util.List;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.ComponentType;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.handlers.NewComponentTypeAction;
import alma.obops.tmcdbgui.utils.conversation.ComponentTypeConversationUtils;

/**
 * The <code>ComponentTypeSelectionDialog</code> is used to select a
 * Component Type from all the available component types.
 * This is useful for wizards and views that need to work with a given
 * ComponentType.
 * 
 * The returned type of this dialog is {@link ComponentType}
 * @author rtobar, Mar 2, 2010
 *
 */
public class ComponentTypeSelectionDialog extends ElementListSelectionDialog {

	public ComponentTypeSelectionDialog(Shell parent, ILabelProvider renderer) {
		super(parent, renderer);

		loadComponentTypes();
		setIgnoreCase(true);
		setMessage("Select a component type");
		setMultipleSelection(false);
	}

	protected Control createDialogArea(Composite parent) {

		final Composite comp = new Composite(parent, SWT.NONE);
		comp.setLayout(new GridLayout(2, false));
		comp.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		GridData gd = new GridData(SWT.FILL, SWT.FILL, true, true);
		gd.horizontalSpan = 2;
		Control control = super.createDialogArea(comp);
		control.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		gd.horizontalIndent = 10;
		Label iconLabel = new Label(comp, SWT.NONE);
		iconLabel.setImage(RcpUtils.getImage("icons/component-type-new.png"));
		iconLabel.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Link newComponentTypeLink = new Link(comp, SWT.NONE);
		newComponentTypeLink.setText("<a href=\"create\">Create a new component type</a>");
		newComponentTypeLink.setLayoutData(gd);
		newComponentTypeLink.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				new NewComponentTypeAction(getShell()).run();
			}
		});
		newComponentTypeLink.setLayoutData(gd);

		getShell().setText("Component Type selection");
		return control;
	}

	private void loadComponentTypes() {
		List<ComponentType> types = null;
		try {
			 types = ComponentTypeConversationUtils.getInstance().findByName("");
		} catch(Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
		setElements(types.toArray(new ComponentType[0]));
	}
}