/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.dialogs;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.utils.conversation.ComponentConversationUtils;

/**
 * The <code>ComponentSelectionDialog</code> is used to select a
 * Component from all the available components for a given Configuration.
 * This is useful for wizards and views that need to work with a given
 * Components.
 * 
 * The returned type of this dialog is {@link Component}.
 * 
 * @author rtobar, Oct 16th, 2010
 *
 */
public class ComponentSelectionDialog extends ElementListSelectionDialog {

	public ComponentSelectionDialog(Shell parent, ILabelProvider renderer, Configuration config) {
		super(parent, renderer);

		try {
			ComponentConversationUtils.getInstance().hydrateComponents(config);
		} catch(Exception e) {
			e.printStackTrace();
		}
		setElements(config.getComponents().toArray(new Component[0]));

		setIgnoreCase(true);
		setMessage("Select a component");
		setMultipleSelection(false);
	}

	protected Control createDialogArea(Composite parent) {
		Control control = super.createDialogArea(parent);
		getShell().setText("Component selection");
		return control;
	}
	
}