/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.acs.tmcdb.ReductionThreshold;
import alma.obops.tmcdb.alarms.ui.widgets.ReductionThresholdAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;

public class ReductionThresholdAttributesWizardPage extends WizardPage implements StatusListener 
{
	private static final String DEFINE_THE_REDUCTION_THRESHOLD = "Define the reduction threshold";
	private static final String PAGENAME = "Reduction Threshold";
	private ReductionThresholdAttributesComposite reductionThresholdComposite;
	private ReductionThreshold reductionThreshold;
	
	public ReductionThresholdAttributesWizardPage(ReductionThreshold threshold) 
	{
		super(PAGENAME);
		this.reductionThreshold = threshold;
		this.setTitle(PAGENAME);
		this.setDescription(DEFINE_THE_REDUCTION_THRESHOLD);
	}

	@Override
	public void createControl(Composite parent) 
	{
		reductionThresholdComposite =  
			new ReductionThresholdAttributesComposite(parent, SWT.NONE, this.reductionThreshold, this, null);
		
		setControl(reductionThresholdComposite);
	}

	@Override
	public void notifyOfCompletion(boolean complete) {
		this.setPageComplete(complete);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) {
		this.setErrorMessage(newStatusMessage);
	}
	
	public ReductionThreshold getThreshold()
	{
		return this.reductionThresholdComposite.getThreshold();
	}

	public void setReductionThreshold(ReductionThreshold threshold) {
		this.reductionThreshold = threshold;
		reductionThresholdComposite.setThreshold(threshold);
	}
}
