/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdb.alarms.ui.widgets.LocationAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;

public class LocationAttributesWizardPage extends WizardPage implements StatusListener 
{
	private LocationAttributesComposite locationAttributesComposite;
	
	/**
	 * Constructor.
	 * @param pageName the name of the wizard page.
	 */
	public LocationAttributesWizardPage( String pageName ) 
	{
		super(pageName);
		setTitle( pageName );
		setDescription( "Specify the location's attributes" );
	}

	@Override
	public void createControl(Composite parent) 
	{
		locationAttributesComposite = new LocationAttributesComposite(parent, SWT.None, this);
		this.setControl(locationAttributesComposite);
		this.setPageComplete(false);
	}

	@Override
	public void notifyOfCompletion(boolean complete) {
		this.setPageComplete(complete);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) {
		this.setErrorMessage(newStatusMessage);
	}

	public String getRoom() {
		return this.locationAttributesComposite.getRoom();
	}

	public String getPosition() {
		return this.locationAttributesComposite.getPosition();
	}
	
	public String getBuilding() {
		return this.locationAttributesComposite.getBuilding();
	}
	
	public String getMnemonic() {
		return this.locationAttributesComposite.getMnemonic();
	}
	
	public String getFloor() {
		return this.locationAttributesComposite.getFloor();
	}
}
