/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.acs.tmcdb.FaultFamily;
import alma.obops.tmcdb.alarms.ui.widgets.FaultCodeAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;

public class FaultCodeAttributesWizardPage extends WizardPage implements StatusListener 
{
	private FaultFamily faultFamily;
	private FaultCodeAttributesComposite faultCodeAttributesComposite;
	
	/**
	 * Constructor.
	 * @param pageName the name of the wizard page.
	 * @param config the configuration in which the new antenna will 'live'.
	 */
	public FaultCodeAttributesWizardPage( String pageName, FaultFamily family) 
	{
		super(pageName);
		this.faultFamily = family;
		setTitle( pageName );
		setDescription( "Specify the fault code's attributes" );
	}

	@Override
	public void createControl(Composite parent) 
	{
		faultCodeAttributesComposite = new FaultCodeAttributesComposite(parent, SWT.None, this, faultFamily);
		this.setControl(faultCodeAttributesComposite);
		this.setPageComplete(false);
	}

	@Override
	public void notifyOfCompletion(boolean complete) {
		this.setPageComplete(complete);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) {
		this.setErrorMessage(newStatusMessage);
	}

	public String getConsequence() {
		return this.faultCodeAttributesComposite.getConsequence();
	}

	public String getCause() {
		return this.faultCodeAttributesComposite.getCause();
	}
	
	public String getAction() {
		return this.faultCodeAttributesComposite.getAction();
	}

	public boolean getInstant() {
		return this.faultCodeAttributesComposite.getInstant();
	}

	public Integer getPriority() {
		return this.faultCodeAttributesComposite.getPriority();
	}

	public String getProblemDescription() {
		return this.faultCodeAttributesComposite.getProblemDescription();
	}

	public Integer getValue() {
		return this.faultCodeAttributesComposite.getCodeValue();
	}
}
