/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Location;
import alma.obops.tmcdb.alarms.ui.widgets.LocationSelectionDialog;
import alma.obops.tmcdb.alarms.ui.widgets.providers.LocationSelectionDialogLabelProvider;

public class ChooseLocationWizardPage extends WizardPage 
{
	private Location location;

	public ChooseLocationWizardPage(Location location) {
		super("Location Chooser");
		setTitle("Location Chooser");
		setDescription("Choose a location");
		this.location = location;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* Component Type */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label locationLabel = new Label(composite, SWT.NONE);
		locationLabel.setText("Location");
		locationLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		final Text locationText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		locationText.setText( location == null ? "" : location.getMnemonic() );
		locationText.setEditable(false);
		locationText.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Button browseButton = new Button(composite, SWT.PUSH);
		browseButton.setText("Browse...");
		browseButton.setLayoutData(gd);

		// Setup the browser button and logic
		browseButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				ElementListSelectionDialog d = new LocationSelectionDialog(getShell(), new LocationSelectionDialogLabelProvider());
				d.open();
				Object locations[] = d.getResult();
				if( locations != null && locations.length == 1 ) {
					location = (Location)locations[0];
					locationText.setText( location.getMnemonic() );
				}
				toggleIsComplete();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		setControl( composite );
		toggleIsComplete();
	}

	private void toggleIsComplete() {

		// Errors
		if( getLocation() == null ) {
			setErrorMessage("Location missing");
			setPageComplete(false);
		}

		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}

	public Location getLocation() {
		return location;
	}
}
