/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.FaultFamily;
import alma.acs.tmcdb.FaultMember;
import alma.obops.tmcdb.alarms.ui.widgets.FaultMemberSelectionDialog;
import alma.obops.tmcdb.alarms.ui.widgets.providers.FaultMemberSelectionDialogLabelProvider;

public class ChooseFaultMemberWizardPage extends WizardPage 
{
	private IWorkbenchWindow window;
	private FaultMember faultMember;
	private FaultFamily owningFamily;

	public ChooseFaultMemberWizardPage(IWorkbenchWindow window, FaultMember faultMember, FaultFamily owningFamily) {
		super("FaultMember Chooser");
		setTitle("FaultMember Chooser");
		setDescription("Choose a fault member");
		this.faultMember = faultMember;
		this.owningFamily = owningFamily;
		this.window = window;
	}
	
	public ChooseFaultMemberWizardPage(IWorkbenchWindow window, FaultMember faultMember, FaultFamily owningFamily, String description) 
	{
		this(window, faultMember, owningFamily);
		this.setDescription(description);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* Component Type */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label compTypeLabel = new Label(composite, SWT.NONE);
		compTypeLabel.setText(getDescription());
		compTypeLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		final Text faultMemberText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		faultMemberText.setText( faultMember == null ? "" : faultMember.getMemberName() );
		faultMemberText.setEditable(false);
		faultMemberText.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Button browseButton = new Button(composite, SWT.PUSH);
		browseButton.setText("Browse...");
		browseButton.setLayoutData(gd);


		// Setup the browser button and logic
		browseButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				ElementListSelectionDialog d = new FaultMemberSelectionDialog(window, new FaultMemberSelectionDialogLabelProvider(), owningFamily);
				d.open();
				Object objs[] = d.getResult();
				if( objs != null && objs.length == 1 ) {
					faultMember = (FaultMember)objs[0];
					faultMemberText.setText( faultMember.getMemberName() );
				}
				toggleIsComplete();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		setControl( composite );
		toggleIsComplete();
	}

	private void toggleIsComplete() {

		// Errors
		if( getFaultMember() == null ) {
			setErrorMessage("FaultMember missing");
			setPageComplete(false);
		}

		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}
	
	public FaultMember getFaultMember() {
		return faultMember;
	}

	public void setFaultFamily(FaultFamily family) {
		this.owningFamily = family;
	}
}
