/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultFamily;
import alma.obops.tmcdb.alarms.ui.actions.listeners.IUpdateFaultFamilyListener;
import alma.obops.tmcdb.alarms.ui.widgets.FaultFamilySelectionDialog;
import alma.obops.tmcdb.alarms.ui.widgets.providers.FaultFamilySelectionDialogLabelProvider;

public class ChooseFaultFamilyWizardPage extends WizardPage 
{
	private IWorkbenchWindow window;
	private FaultFamily faultFamily;
	private Configuration configuration;
	private IUpdateFaultFamilyListener listener;

	public ChooseFaultFamilyWizardPage(IWorkbenchWindow window, Configuration owningConfig, IUpdateFaultFamilyListener listener) 
	{
		super("FaultFamily Chooser");
		setTitle("FaultFamily Chooser");
		setDescription("Choose a fault family");
		this.configuration = owningConfig;
		this.window = window;
		this.listener = listener;
	}
	
	public ChooseFaultFamilyWizardPage(IWorkbenchWindow window, Configuration owningConfiguration, String description, IUpdateFaultFamilyListener listener) 
	{
		this(window, owningConfiguration, listener);
		this.setDescription(description);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* Component Type */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label label = new Label(composite, SWT.NONE);
		label.setText(getDescription());
		label.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		final Text faultFamilyText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		faultFamilyText.setEditable(false);
		faultFamilyText.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Button browseButton = new Button(composite, SWT.PUSH);
		browseButton.setText("Browse...");
		browseButton.setLayoutData(gd);

		// Setup the browser button and logic
		browseButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				ElementListSelectionDialog d = new FaultFamilySelectionDialog(window, new FaultFamilySelectionDialogLabelProvider(), configuration, getDescription());
				d.open();
				Object objs[] = d.getResult();
				if( objs != null && objs.length == 1 ) {
					faultFamily = (FaultFamily)objs[0];
					faultFamilyText.setText( faultFamily.getFamilyName() );
					if(listener != null) {
						listener.updateFaultFamily(faultFamily);
					}
				}
				toggleIsComplete();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		setControl( composite );
		toggleIsComplete();
	}

	private void toggleIsComplete() {

		// Errors
		if( getFaultFamily() == null ) {
			setErrorMessage("FaultFamily missing");
			setPageComplete(false);
		}

		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}
	
	public FaultFamily getFaultFamily() {
		return faultFamily;
	}
}
