/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.FaultCode;
import alma.acs.tmcdb.FaultFamily;
import alma.obops.tmcdb.alarms.ui.actions.listeners.IUpdateFaultCodeListener;
import alma.obops.tmcdb.alarms.ui.widgets.FaultCodeSelectionDialog;
import alma.obops.tmcdb.alarms.ui.widgets.providers.FaultCodeSelectionDialogLabelProvider;

public class ChooseFaultCodeWizardPage extends WizardPage 
{
	private FaultCode faultCode;
	private FaultFamily owningFamily;
	private IWorkbenchWindow window;
	private IUpdateFaultCodeListener listener;

	public ChooseFaultCodeWizardPage(IWorkbenchWindow window, FaultCode faultCode, FaultFamily owningFamily, IUpdateFaultCodeListener listener) {
		super("FaultCode Chooser");
		setTitle("FaultCode Chooser");
		setDescription("Choose a faultCode");
		this.window = window;
		this.faultCode = faultCode;
		this.owningFamily = owningFamily;
		this.listener = listener;
	}

	public ChooseFaultCodeWizardPage(IWorkbenchWindow window, FaultCode faultCode, FaultFamily owningFamily, String description, IUpdateFaultCodeListener listener) 
	{
		this(window, faultCode, owningFamily, listener);
		this.setDescription(description);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* Component Type */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label compTypeLabel = new Label(composite, SWT.NONE);
		compTypeLabel.setText(getDescription());
		compTypeLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		final Text faultCodeText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		faultCodeText.setText( faultCode == null ? "" : faultCode.getCodeValue().toString() );
		faultCodeText.setEditable(false);
		faultCodeText.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Button browseCompTypes = new Button(composite, SWT.PUSH);
		browseCompTypes.setText("Browse...");
		browseCompTypes.setLayoutData(gd);


		// Setup the browser button and logic
		browseCompTypes.addSelectionListener(new SelectionListener() 
		{
			public void widgetSelected(SelectionEvent e) {
				ElementListSelectionDialog d = new FaultCodeSelectionDialog(window, new FaultCodeSelectionDialogLabelProvider(), owningFamily);
				d.open();
				Object objs[] = d.getResult();
				if( objs != null && objs.length == 1 ) {
					faultCode = (FaultCode)objs[0];
					faultCodeText.setText( faultCode.getCodeValue().toString() );
					if(listener != null) {
						listener.updateFaultCode(faultCode.getCodeValue().toString());
					}
				}
				toggleIsComplete();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		setControl( composite );
		toggleIsComplete();
	}

	private void toggleIsComplete() 
	{
		if( getFaultCode() == null ) {
			setErrorMessage("FaultCode missing");
			setPageComplete(false);
		}
		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}

	public FaultCode getFaultCode() {
		return faultCode;
	}

	public void setFaultFamily(FaultFamily family) 
	{
		this.owningFamily = family;
	}
}
