/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Contact;
import alma.obops.tmcdb.alarms.ui.widgets.ContactSelectionDialog;
import alma.obops.tmcdb.alarms.ui.widgets.providers.ContactSelectionDialogLabelProvider;

public class ChooseContactWizardPage extends WizardPage 
{
	private Contact contact;

	public ChooseContactWizardPage(Contact contact) {
		super("Contact Chooser");
		setTitle("Contact Chooser");
		setDescription("Choose a contact");
		this.contact = contact;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* Contact */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label contactLabel = new Label(composite, SWT.NONE);
		contactLabel.setText("Contact");
		contactLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		final Text contactText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		contactText.setText( contact == null ? "" : contact.getContactName() );
		contactText.setEditable(false);
		contactText.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Button browseContactsButton = new Button(composite, SWT.PUSH);
		browseContactsButton.setText("Browse...");
		browseContactsButton.setLayoutData(gd);


		// Setup the browser button and logic
		browseContactsButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				ElementListSelectionDialog d = new ContactSelectionDialog(getShell(), new ContactSelectionDialogLabelProvider());
				d.open();
				Object contacts[] = d.getResult();
				if( contacts != null && contacts.length == 1 ) {
					contact = (Contact)contacts[0];
					contactText.setText( contact.getContactName() );
				}
				toggleIsComplete();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		setControl( composite );
		toggleIsComplete();
	}

	private void toggleIsComplete() {

		// Errors
		if( getContact() == null ) {
			setErrorMessage("Contact missing");
			setPageComplete(false);
		}

		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}

	public Contact getContact() {
		return contact;
	}
}
