/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards.wizardpages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdb.alarms.ui.widgets.AlarmCategoryAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;

public class AlarmCategoryAttributesWizardPage extends WizardPage implements StatusListener 
{
	private Configuration configuration;
	private AlarmCategoryAttributesComposite alarmCategoryAttributesComposite;
	
	/**
	 * Constructor.
	 * @param pageName the name of the wizard page.
	 * @param config the configuration in which the new antenna will 'live'.
	 */
	public AlarmCategoryAttributesWizardPage( String pageName, Configuration config) 
	{
		super(pageName);
		this.configuration = config;
		setTitle( pageName );
		setDescription( "Specify the alarm category's attributes" );
	}

	@Override
	public void createControl(Composite parent) 
	{
		alarmCategoryAttributesComposite = new AlarmCategoryAttributesComposite(parent, SWT.None, this, configuration);
		this.setControl(alarmCategoryAttributesComposite);
		this.setPageComplete(false);
	}

	@Override
	public void notifyOfCompletion(boolean complete) {
		this.setPageComplete(complete);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) {
		this.setErrorMessage(newStatusMessage);
	}

	public boolean isDefault() {
		return this.alarmCategoryAttributesComposite.isDefault();
	}

	public String getCategoryPath() {
		return this.alarmCategoryAttributesComposite.getCategoryPath();
	}

	public String getCategoryName() {
		return this.alarmCategoryAttributesComposite.getCategoryName();
	}

	public String getCategoryDescription() {
		return this.alarmCategoryAttributesComposite.getCategoryDescription();
	}}
