/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultFamily;
import alma.obops.tmcdb.alarms.ui.actions.listeners.IAssignNodeReductionLinkAttributes;
import alma.obops.tmcdb.alarms.ui.actions.listeners.IUpdateFaultFamilyListener;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.ChooseFaultCodeWizardPage;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.ChooseFaultFamilyWizardPage;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.ChooseFaultMemberWizardPage;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.ChooseAlarmDefinitionWizardPage;

public class AddNodeReductionLinkWizard extends Wizard implements IUpdateFaultFamilyListener
{
	private ChooseAlarmDefinitionWizardPage childAlarmDefinitionPage;
	private ChooseFaultFamilyWizardPage parentFamilyPage;
	private ChooseFaultMemberWizardPage parentMemberPage;
	private ChooseFaultCodeWizardPage parentCodePage;
	private Configuration configuration;
	
	private IAssignNodeReductionLinkAttributes action;
	private IWorkbenchWindow window;

	public AddNodeReductionLinkWizard(IWorkbenchWindow window, IAssignNodeReductionLinkAttributes callback, Configuration config) 
	{
		this.action = callback;
		this.window = window;
		this.configuration = config;
	}

	@Override
	public boolean performFinish() 
	{
		action.setChildFaultCode(childAlarmDefinitionPage.getFaultCode());
		action.setChildFaultFamily(childAlarmDefinitionPage.getFaultFamily());
		action.setChildFaultMember(childAlarmDefinitionPage.getFaultMember());
		action.setParentFaultCode(parentCodePage.getFaultCode());
		action.setParentFaultMember(parentMemberPage.getFaultMember());
		action.setParentFaultFamily(parentFamilyPage.getFaultFamily());
		return true;
	}

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
	public void addPages() 
	{
		this.parentFamilyPage = new ChooseFaultFamilyWizardPage(window, configuration, "Parent alarm FF", this);
		addPage(parentFamilyPage);
		
		this.parentMemberPage = new ChooseFaultMemberWizardPage(window, null, null, "Parent alarm FM");
		addPage(parentMemberPage);
		
		this.parentCodePage = new ChooseFaultCodeWizardPage(window, null, null, "Parent alarm FC", null);
		addPage(parentCodePage);
		
		this.childAlarmDefinitionPage = 
			new ChooseAlarmDefinitionWizardPage("Choose child alarm", configuration);
		
		addPage( childAlarmDefinitionPage );
	}

	@Override
	public void updateFaultFamily(FaultFamily family) {
		this.parentMemberPage.setFaultFamily(family);
		this.parentCodePage.setFaultFamily(family);
	}
}
