/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.acs.tmcdb.FaultFamily;
import alma.obops.tmcdb.alarms.ui.actions.listeners.IAssignFaultMemberAttributes;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.ChooseLocationWizardPage;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.FaultMemberAttributesWizardPage;

public class AddFaultMemberWizard extends Wizard 
{
	private FaultMemberAttributesWizardPage attributesPage;
	private ChooseLocationWizardPage locationPage;
	private IAssignFaultMemberAttributes action;
	private FaultFamily owningFamily;

	public AddFaultMemberWizard(IAssignFaultMemberAttributes callback,FaultFamily owningFamily) 
	{
		this.action = callback;
		this.owningFamily = owningFamily;
	}

	@Override
	public boolean performFinish() 
	{
		action.setLocation(this.locationPage.getLocation());
		action.setMemberName(this.attributesPage.getMemberName());
		return true;
	}

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
	public void addPages() {
		this.attributesPage = new FaultMemberAttributesWizardPage( "New Fault Member", owningFamily );
		addPage( attributesPage );

		this.locationPage = new ChooseLocationWizardPage(null);
		addPage( locationPage );
	}
}
