/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.wizards;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.FaultMember;
import alma.obops.tmcdb.alarms.ui.actions.listeners.IAssignAlarmDefinitionAttributes;
import alma.obops.tmcdb.alarms.ui.wizards.wizardpages.ChooseFaultCodeWizardPage;

public class AddAlarmDefinitionWizard extends Wizard 
{
	private ChooseFaultCodeWizardPage faultCodePage;
//	private ChooseFaultMemberWizardPage faultMemberPage;
	private IAssignAlarmDefinitionAttributes action;
	private IWorkbenchWindow window;
	private FaultMember owningMember;

	public AddAlarmDefinitionWizard(IWorkbenchWindow window, IAssignAlarmDefinitionAttributes callback, FaultMember owningMember) 
	{
		this.action = callback;
		this.owningMember = owningMember;
		this.window = window;
	}

	@Override
	public boolean performFinish() 
	{
		action.setFaultCode(this.faultCodePage.getFaultCode());
//		action.setFaultMember(this.faultMemberPage.getFaultMember());
		return true;
	}

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
	public void addPages() 
	{
//		this.faultMemberPage = new ChooseFaultMemberWizardPage(window, null, owningMember.getFaultFamily());
//		addPage( faultMemberPage );
		this.faultCodePage = new ChooseFaultCodeWizardPage(window, null, owningMember.getFaultFamily(), null);
		addPage( faultCodePage );
	}
}
