/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.widgets.providers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Contact;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

public class ContactSelectionDialogLabelProvider implements ILabelProvider 
{
	public Image getImage(Object element) {
		return RcpUtils.getImage("icons/contact.png");
	}

	public String getText(Object element) {
		if( element instanceof Contact ) {
			Contact contact = (Contact)element; 
			return contact.getContactName();	
		}
		return null;
	}

	public void addListener(ILabelProviderListener listener) { }

	public void dispose() {}

	public boolean isLabelProperty(Object element, String property) { return false; }

	public void removeListener(ILabelProviderListener listener) { }

}
