/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.AlarmDefinition;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class AlarmDefinitionSelectionDialog extends ElementListSelectionDialog 
{
	private Configuration configuration;
	private IWorkbenchWindow window;

	public AlarmDefinitionSelectionDialog(IWorkbenchWindow window, ILabelProvider renderer, Configuration config, String msg) 
	{
		super(window.getShell(), renderer);
		this.configuration = config;
		this.window = window;
		setIgnoreCase(true);
		setMessage(msg);
		setMultipleSelection(false);
		loadAlarmDefs();
	}
	
	protected Control createDialogArea(Composite parent) 
	{
		final Composite comp = new Composite(parent, SWT.NONE);
		comp.setLayout(new GridLayout(2, false));
		comp.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		GridData gd = new GridData(SWT.FILL, SWT.FILL, true, true);
		gd.horizontalSpan = 2;
		Control control = super.createDialogArea(comp);
		control.setLayoutData(gd);

		getShell().setText("Alarm definition selection");
		return control;
	}

	private synchronized void loadAlarmDefs() 
	{
		try {
			new ProgressMonitorDialog(window.getShell()).
			run(true, false, new ThreadForSettingInput());
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			throw new RuntimeException("Could not invoke hydration thread", e);
		} catch (InterruptedException e) {
			e.printStackTrace();
			throw new RuntimeException("Hydration thread was interrupted", e);
		}
	}
	
	private class ThreadForSettingInput implements IRunnableWithProgress
	{
		/**
		 * LongRunningOperation constructor
		 * 
		 * @param indeterminate whether the animation is unknown
		 */
		public ThreadForSettingInput() 
		{
		}

		/**
		 * Runs the long running operation
		 * 
		 * @param monitor the progress monitor
		 */
		public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException 
		{
			monitor.beginTask("Hydrating...", IProgressMonitor.UNKNOWN);
			List<AlarmDefinition> alarmDefinitions = null;
			try {
				alarmDefinitions = AlarmConversationUtils.getInstance().findAlarmDefinitionsByConfiguration(configuration);
			} catch(Exception e) {
				e.printStackTrace();
			}
			if(alarmDefinitions != null) 
			{
				AlarmDefinition[] elementsArray = alarmDefinitions.toArray(new AlarmDefinition[0]);
				setElements(elementsArray);
			} else {
				setElements(null);
			}
			monitor.done();
		}

		
		
		
	}
}