/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.views.providers;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.tree.helpers.ThreeColumnDomainObjectHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.factory.AlarmHelperFactory;
import alma.obops.tmcdb.alarms.ui.tree.helpers.factory.ThreeColumnDomainObjectHelperFactory;

public class AlarmCategoriesTreeLabelProvider extends ColumnLabelProvider implements IStyledLabelProvider 
{
	protected int columnIndex;
	protected ThreeColumnDomainObjectHelperFactory helperFactory;

	/**
	 * Constructor.
	 * 
	 * @param columnIndex
	 *            Index of the column we are providing for.
	 * @param helperFactory the DomainObjectHelperFactory to use when creating helper classes.
	 */
	public AlarmCategoriesTreeLabelProvider( int columnIndex ) {
		this.columnIndex = columnIndex;
		this.helperFactory = new AlarmHelperFactory();
	}

	@Override
	public Image getImage( Object element ) 
	{
		ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(element);
		Image retVal = null;
		if(null != helper)
		{
			switch(columnIndex) {
			case 0:
				retVal = helper.getFirstColumnImage();
				break;
			case 1:
				retVal = helper.getSecondColumnImage();
				break;
			case 2: 
				retVal = helper.getThirdColumnImage();
				break;
			default:
				retVal = null;
			}
		}

		return retVal;
	}

	@Override
	public String getText( Object element ) 
	{
		String retVal = null;
		ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(element);
		if(null != helper)
		{
			switch(columnIndex) {
			case 0:
				retVal = helper.getFirstColumnText();
				break;
			case 1:
				retVal = helper.getSecondColumnText();
				break;
			case 2: 
				retVal = helper.getThirdColumnText();
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}

	@Override
	public Font getFont(Object element) {
		ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(element);
		if( helper != null ) {
			return helper.getFont();
		}
		return super.getFont(element);
	}


	@Override
	public Color getForeground(Object element) {
		ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(element);
		if( helper != null ) {
			return helper.getForeground();
		}
		return super.getForeground(element);
	}

	@Override
	public StyledString getStyledText(Object element) {
		return new StyledString(getText(element));
	}
}
