/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.views.providers;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdb.alarms.ui.tree.helpers.ThreeColumnDomainObjectHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.factory.AlarmHelperFactory;

public class AlarmCategoriesTreeContentsProvider implements ITreeContentProvider 
{
	protected AlarmHelperFactory helperFactory;
	
	public AlarmCategoriesTreeContentsProvider()
	{
		this.helperFactory = new AlarmHelperFactory();
	}
	
	@Override
	public Object[] getChildren(Object parent) {
		ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(parent);
    	Object[] retVal = helper.getChildren();
    	return retVal;
	}

	/**
     * This method gets called with the tree's initial input, that is, an array
     * of AlarmDefinitions and AlarmCategories
     * 
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements( Object element ) 
    {
        if( element instanceof Object[] )
            return (Object[]) element;

		// Should never happen
        throw new IllegalArgumentException("Unsupported class: " + element.getClass().getName());
    }

    /**
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
     */
    public Object getParent( Object element ) {
        return null;
    }

    /**
     * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
     */
    public boolean hasChildren( Object element ) 
    {
    	ThreeColumnDomainObjectHelper helper = helperFactory.getHelper(element);
    	boolean hasChildren = false;
    	if(null != helper) {
    	   hasChildren = helper.hasChildren();
    	} 
    	
    	return hasChildren;
    }

    /**
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object)
     */
    public void inputChanged( Viewer viewer, Object oldIn, Object newIn ) {
        // no-op
    }

	@Override
	public void dispose() {
		// TODO Auto-generated method stub
	}

	public void setConfiguration(Configuration conf) {
		this.helperFactory.setConfiguration(conf);
	}    
}
