/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.views.comparers;

import org.eclipse.jface.viewers.IElementComparer;

import alma.acs.tmcdb.AlarmCategory;
import alma.acs.tmcdb.AlarmDefinition;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultMember;
import alma.acs.tmcdb.FaultCode;
import alma.acs.tmcdb.FaultFamily;
import alma.acs.tmcdb.FaultMember;
import alma.acs.tmcdb.ReductionLink;
import alma.acs.tmcdb.ReductionThreshold;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.AlarmCategoryList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.AlarmDefinitionList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.DefaultMemberList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.FaultCodeList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.FaultFamilyList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.FaultMemberList;
import alma.tmcdb.domain.HwConfiguration;

public class AlarmCategoriesTreeComparer implements IElementComparer 
{
	@Override
	public boolean equals(Object obj1, Object obj2) 
	{
		boolean retVal = false;
				
		if(!obj1.getClass().equals(obj2.getClass())) {
			retVal = false;
		}
		else {
			if(obj1 instanceof Object[]) {
				Object[] item1 = (Object[]) obj1;
				Object[] item2 = (Object[]) obj2;
				retVal = (item1.length == item2.length);
				retVal &= item1[0].getClass().equals(item2[0].getClass());
				
				if(item1[0] instanceof HwConfiguration && item2[0] instanceof HwConfiguration) 
				{
					HwConfiguration hwconf1 = (HwConfiguration)item1[0];
					HwConfiguration hwconf2 = (HwConfiguration)item2[0];
					retVal &= hwconf1.getId().equals(hwconf2.getId());
				}
			}
			else if(obj1 instanceof HwConfiguration) {
				HwConfiguration item1 = (HwConfiguration) obj1;
				HwConfiguration item2 = (HwConfiguration) obj2;
				retVal = item1.getId().equals(item2.getId());
			}
			else if(obj1 instanceof Configuration) {
				Configuration config1 = (Configuration) obj1;
				Configuration config2 = (Configuration) obj2;
				retVal = config1.getConfigurationId().equals(config2.getConfigurationId());
			}
			else if(obj1 instanceof AlarmCategoryList) {
				AlarmCategoryList item1 = (AlarmCategoryList) obj1;
				AlarmCategoryList item2 = (AlarmCategoryList) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
			}
			else if(obj1 instanceof AlarmCategory) {
				AlarmCategory item1 = (AlarmCategory) obj1;
				AlarmCategory item2 = (AlarmCategory) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal &= item1.getAlarmCategoryId().equals(item2.getAlarmCategoryId());
			}
			else if(obj1 instanceof FaultFamilyList) {
				FaultFamilyList item1 = (FaultFamilyList) obj1;
				FaultFamilyList item2 = (FaultFamilyList) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal &= item1.getAlarmCategory().getAlarmCategoryId().equals(item2.getAlarmCategory().getAlarmCategoryId());
			}
			else if(obj1 instanceof FaultMemberList) {
				FaultMemberList item1 = (FaultMemberList) obj1;
				FaultMemberList item2 = (FaultMemberList) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal &= item1.getFaultFamily().getFaultFamilyId().equals(item2.getFaultFamily().getFaultFamilyId());
			}
			else if(obj1 instanceof FaultCodeList) {
				FaultCodeList item1 = (FaultCodeList) obj1;
				FaultCodeList item2 = (FaultCodeList) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal &= item1.getFaultFamily().getFaultFamilyId().equals(item2.getFaultFamily().getFaultFamilyId());
			}
			else if(obj1 instanceof DefaultMemberList) {
				DefaultMemberList item1 = (DefaultMemberList) obj1;
				DefaultMemberList item2 = (DefaultMemberList) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal &= item1.getFaultFamily().getFaultFamilyId().equals(item2.getFaultFamily().getFaultFamilyId());
			}
			else if(obj1 instanceof AlarmDefinitionList) {
				AlarmDefinitionList item1 = (AlarmDefinitionList) obj1;
				AlarmDefinitionList item2 = (AlarmDefinitionList) obj2;
				retVal = item1.getFaultFamily().getFaultFamilyId().equals(item2.getFaultFamily().getFaultFamilyId());
				retVal &= item1.getFaultFamily().getConfiguration().getConfigurationId().equals(item2.getFaultFamily().getConfiguration().getConfigurationId());
				retVal &= (item1.getStart() == item2.getStart());
			}
			else if(obj1 instanceof FaultFamily) {
				FaultFamily item1 = (FaultFamily) obj1;
				FaultFamily item2 = (FaultFamily) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal &= item1.getFaultFamilyId().equals(item2.getFaultFamilyId());
			}
			else if(obj1 instanceof FaultMember) {
				FaultMember item1 = (FaultMember) obj1;
				FaultMember item2 = (FaultMember) obj2;
				retVal = item1.getFaultFamily().getConfiguration().getConfigurationId().equals(item2.getFaultFamily().getConfiguration().getConfigurationId());
				retVal &= item1.getFaultMemberId().equals(item2.getFaultMemberId());
			}
			else if(obj1 instanceof FaultCode) {
				FaultCode item1 = (FaultCode) obj1;
				FaultCode item2 = (FaultCode) obj2;
				retVal = item1.getFaultFamily().getConfiguration().getConfigurationId().equals(item2.getFaultFamily().getConfiguration().getConfigurationId());
				retVal &= item1.getFaultCodeId().equals(item2.getFaultCodeId());
			}
			else if(obj1 instanceof DefaultMember) {
				DefaultMember item1 = (DefaultMember) obj1;
				DefaultMember item2 = (DefaultMember) obj2;
				retVal = item1.getFaultFamily().getConfiguration().getConfigurationId().equals(item2.getFaultFamily().getConfiguration().getConfigurationId());
				retVal &= item1.getDefaultMemberId().equals(item2.getDefaultMemberId());
			}
			else if(obj1 instanceof AlarmDefinition) {
				AlarmDefinition item1 = (AlarmDefinition) obj1;
				AlarmDefinition item2 = (AlarmDefinition) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal = item1.getAlarmDefinitionId().equals(item2.getAlarmDefinitionId());
			}
			else if(obj1 instanceof ReductionLink) {
				ReductionLink item1 = (ReductionLink) obj1;
				ReductionLink item2 = (ReductionLink) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal = item1.getReductionLinkId().equals(item2.getReductionLinkId());
			}
			else if(obj1 instanceof ReductionThreshold) {
				ReductionThreshold item1 = (ReductionThreshold) obj1;
				ReductionThreshold item2 = (ReductionThreshold) obj2;
				retVal = item1.getConfiguration().getConfigurationId().equals(item2.getConfiguration().getConfigurationId());
				retVal = item1.getAlarmDefinitionId().equals(item2.getAlarmDefinitionId());
			}
			else {
				throw new IllegalArgumentException("Class not supported: " + obj1.getClass().toString());
			}
		}
		
		return retVal;
	}

	@Override
	public int hashCode(Object obj) 
	{
		int retVal = 0;

		if(obj instanceof Object[]) 
		{
			retVal = ((Object[]) obj)[0].hashCode();
			if(((Object[])obj)[0] instanceof HwConfiguration) {
				HwConfiguration conf = (HwConfiguration)((Object[])obj)[0];
				retVal = conf.getId().hashCode();
			}
		}
		else if(obj instanceof HwConfiguration) {
			HwConfiguration config1 = (HwConfiguration) obj;
			retVal = config1.getId().hashCode();
		}
		else if(obj instanceof HwConfiguration[]) {
			HwConfiguration config1 = ((HwConfiguration[]) obj)[0];
			retVal = config1.getId().hashCode();
		}
		else if(obj instanceof Configuration) {
			Configuration config1 = (Configuration) obj;
			retVal = config1.getConfigurationId().hashCode();
		}
		else if(obj instanceof AlarmCategoryList) {
			AlarmCategoryList item1 = (AlarmCategoryList) obj;
			retVal = item1.getConfiguration().getConfigurationId().hashCode();
		}
		else if(obj instanceof AlarmCategory) {
			AlarmCategory item1 = (AlarmCategory) obj;
			retVal &= item1.getAlarmCategoryId().hashCode();
		}
		else if(obj instanceof FaultFamilyList) {
			FaultFamilyList item1 = (FaultFamilyList) obj;
			retVal &= item1.getAlarmCategory().getAlarmCategoryId().hashCode();
		}
		else if(obj instanceof FaultMemberList) {
			FaultMemberList item1 = (FaultMemberList) obj;
			retVal &= item1.getFaultFamily().getFaultFamilyId().hashCode();
		}
		else if(obj instanceof FaultCodeList) {
			FaultCodeList item1 = (FaultCodeList) obj;
			retVal &= item1.getFaultFamily().getFaultFamilyId().hashCode();
		}
		else if(obj instanceof DefaultMemberList) {
			DefaultMemberList item1 = (DefaultMemberList) obj;
			retVal &= item1.getFaultFamily().getFaultFamilyId().hashCode();
		}
		else if(obj instanceof AlarmDefinitionList) {
			AlarmDefinitionList item1 = (AlarmDefinitionList) obj;
			retVal = item1.getFaultFamily().getFaultFamilyId().hashCode() + (item1.getStart() * 17);
		}
		else if(obj instanceof FaultFamily) {
			FaultFamily item1 = (FaultFamily) obj;
			retVal &= item1.getFaultFamilyId().hashCode();
		}
		else if(obj instanceof FaultMember) {
			FaultMember item1 = (FaultMember) obj;
			retVal &= item1.getFaultMemberId().hashCode();
		}
		else if(obj instanceof FaultCode) {
			FaultCode item1 = (FaultCode) obj;
			retVal &= item1.getFaultCodeId().hashCode();
		}
		else if(obj instanceof DefaultMember) {
			DefaultMember item1 = (DefaultMember) obj;
			retVal &= item1.getDefaultMemberId().hashCode();
		}
		else if(obj instanceof AlarmDefinition) {
			AlarmDefinition item1 = (AlarmDefinition) obj;
			retVal = item1.getAlarmDefinitionId().hashCode();
		}
		else if(obj instanceof ReductionLink) {
			ReductionLink item1 = (ReductionLink) obj;
			retVal = item1.getReductionLinkId().hashCode();
		}
		else if(obj instanceof ReductionThreshold) {
			ReductionThreshold item1 = (ReductionThreshold) obj;
			retVal = item1.getAlarmDefinitionId().hashCode();
		}
		
		return retVal;
	}
}
