/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.typedlists;

import java.util.ArrayList;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultFamily;
import alma.acs.tmcdb.FaultMember;

public class FaultMemberList extends ArrayList<FaultMember> 
{
	private static final long serialVersionUID = -1286226612613756675L;
	private FaultFamily faultFamily;

	public FaultMemberList(FaultFamily faultFamily) 
	{
		super(faultFamily.getFaultMembers());
		this.faultFamily = faultFamily;
	}
	
	public FaultFamily getFaultFamily()
	{
		return this.faultFamily;
	}
	
	public Configuration getConfiguration() {
		return this.faultFamily.getConfiguration();
	}
	
	@Override
	public int hashCode()
	{
		return faultFamily.hashCode();
	}
	
	@Override 
	public boolean equals(Object obj) 
	{
		boolean retVal = false;
		
		if(obj instanceof FaultMemberList)
		{
			FaultMemberList list2 = (FaultMemberList)obj;
			return this.faultFamily.equals(list2.getFaultFamily());
		}
		
		return retVal;
	}
}
