/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.typedlists;

import java.util.ArrayList;

import alma.acs.tmcdb.AlarmCategory;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultFamily;

public class FaultFamilyList extends ArrayList<FaultFamily>
{
	private static final long serialVersionUID = 5578220734902584741L;
	private Configuration configuration;
	private AlarmCategory alarmCategory;

	public FaultFamilyList(Configuration config, AlarmCategory owningCategory) 
	{
		super(config.getFaultFamilies());
		this.configuration = config;
		this.alarmCategory = owningCategory;
	}
	
	public Configuration getConfiguration()
	{
		return this.configuration;
	}
	
	@Override
	public int hashCode()
	{
		return alarmCategory.hashCode();
	}
	
	@Override 
	public boolean equals(Object obj) 
	{
		boolean retVal = false;
		
		if(obj instanceof FaultFamilyList)
		{
			FaultFamilyList list2 = (FaultFamilyList)obj;
			return this.alarmCategory.equals(list2.alarmCategory);
		}
		
		return retVal;
	}
	
	public AlarmCategory getAlarmCategory() 
	{
		return alarmCategory;
	}
}
