/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.typedlists;

import java.util.ArrayList;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultCode;
import alma.acs.tmcdb.FaultFamily;

public class FaultCodeList extends ArrayList<FaultCode> 
{
	private FaultFamily faultFamily;
	private static final long serialVersionUID = -6384581833912000256L;
	
    public FaultCodeList(FaultFamily owningFamily) 
    {
        super(owningFamily.getFaultCodes());
        this.faultFamily = owningFamily;
    }

	public FaultFamily getFaultFamily() {
		return faultFamily;
	}
	
	public Configuration getConfiguration() {
		return this.faultFamily.getConfiguration();
	}
	
	@Override
	public int hashCode()
	{
		return faultFamily.hashCode();
	}
	
	@Override 
	public boolean equals(Object obj) 
	{
		boolean retVal = false;
		
		if(obj instanceof FaultCodeList)
		{
			FaultCodeList list2 = (FaultCodeList)obj;
			return this.faultFamily.equals(list2.getFaultFamily());
		}
		
		return retVal;
	}
}
