/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.typedlists;

import java.util.ArrayList;
import java.util.List;

import alma.acs.tmcdb.AlarmDefinition;
import alma.acs.tmcdb.FaultFamily;

public class AlarmDefinitionList extends ArrayList<AlarmDefinition> 
{
	private static final long serialVersionUID = -272476950006641583L;
	private int start;
	private int finish;
	private FaultFamily owningFamily;

	public AlarmDefinitionList(List<AlarmDefinition> defs, int start, int finish, FaultFamily faultFamily)
	{
		super(defs);
		this.start = start;
		this.finish = finish;
		this.owningFamily = faultFamily;
	}
	
	public int getStart()
	{
		return this.start;
	}
	
	public int getFinish()
	{
		return this.finish;
	}
	
	@Override
	public int hashCode()
	{
		return owningFamily.hashCode();
	}
	
	@Override 
	public boolean equals(Object obj) 
	{
		boolean retVal = false;
		
		if(obj instanceof AlarmDefinitionList)
		{
			AlarmDefinitionList list2 = (AlarmDefinitionList)obj;
			return this.owningFamily.equals(list2.owningFamily) && this.start == list2.start;
		}
		
		return retVal;
	}
	
	public FaultFamily getFaultFamily() {
		return this.owningFamily;
	}
}
